<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2021-12-27 23:59
 */
interface BuybillcurrDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Buybillcurr 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param buybillcurr primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Buybillcurr buybillcurr
 	 */
	public function insert($buybillcurr);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Buybillcurr buybillcurr
 	 */
	public function update($buybillcurr);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByBuybillid($value);

	public function queryByConversionFactor($value);

	public function queryByBuybilldiscountC($value);

	public function queryByBuybilltotalbillC($value);

	public function queryByBuybillaftertotalbillC($value);

	public function queryByBuybilltotalpayedC($value);

	public function queryByBuybillfinalbillC($value);

	public function queryByBuybilldirectpaymentC($value);

	public function queryByPayedtaxC($value);

	public function queryBySaveConversionFactor($value);


	public function deleteByBuybillid($value);

	public function deleteByConversionFactor($value);

	public function deleteByBuybilldiscountC($value);

	public function deleteByBuybilltotalbillC($value);

	public function deleteByBuybillaftertotalbillC($value);

	public function deleteByBuybilltotalpayedC($value);

	public function deleteByBuybillfinalbillC($value);

	public function deleteByBuybilldirectpaymentC($value);

	public function deleteByPayedtaxC($value);

	public function deleteBySaveConversionFactor($value);


}
?>